-- Trigger for the UPDATE Event
CREATE TRIGGER trgAfterUpdate ON [dbo].[Employee_Test] 
FOR UPDATE
AS
	DECLARE @empid int;
	DECLARE @empname varchar(100);
	DECLARE @empsal decimal(10,2);
	DECLARE @audit_action varchar(100);

	SELECT @empid=i.Emp_ID FROM inserted i;	
	SELECT @empname=i.Emp_Name FROM inserted i;	
	SELECT @empsal=i.Emp_Sal FROM inserted i;	
	
	IF UPDATE(Emp_Name)
		SET @audit_action='Updated Record Name -- After Update Trigger.';
	IF UPDATE(Emp_Sal)
		SET @audit_action='Updated Record Salary -- After Update Trigger.';

	INSERT INTO Employee_Test_Audit(Emp_ID, Emp_Name, Emp_Sal, Audit_Action, Audit_Timestamp) 
	VALUES(@empid, @empname, @empsal, @audit_action, GETDATE());

	PRINT 'AFTER UPDATE Trigger fired.'
GO

 UPDATE Employee_Test
 SET Emp_Sal=1550
 WHERE Emp_ID=6
